<?php
/*
Plugin Name: GeoDirectory - Multinews Theme Compatibility
Plugin URI: http://themeforest.net/item/multinews-multipurpose-wordpress-newsmagazine/8103494
Description: This plugin lets the GeoDirectory Plugin Compatible with multinews theme.
Version: 1.0.1
Author: Momizat
Author URI: http://momizat.com
*/

add_action( 'plugins_loaded', 'mom_action_calls', 10 );
function mom_action_calls(){
	
	/* ACTIONS
	****************************************************************************************/
	// LOAD STYLESHEET
	add_action( 'wp_enqueue_scripts', 'wpgeo_mom_styles' );
	
	// Add body class for styling purposes
	add_filter('body_class','wpgeo_mn_body_class');
	
	// HOME TOP SIDEBAR
	remove_action( 'geodir_home_before_main_content', 'geodir_action_geodir_sidebar_home_top', 10 );
	add_action( 'geodir_before_search_form', 'mom_search_container_open' );
	add_action( 'geodir_after_search_form', 'mom_search_container_close' );
	
	// WRAPPER OPEN ACTIONS
	remove_action( 'geodir_wrapper_open', 'geodir_action_wrapper_open', 10 );
	add_action( 'geodir_wrapper_open', 'mom_action_wrapper_open', 9 );
	
	// WRAPPER CLOSE ACTIONS
	remove_action( 'geodir_wrapper_close', 'geodir_action_wrapper_close', 10);
	add_action( 'geodir_wrapper_close', 'mom_action_wrapper_close', 11);	
	
	// WRAPPER CONTENT OPEN ACTIONS
	remove_action( 'geodir_wrapper_content_open', 'geodir_action_wrapper_content_open', 10 );
	add_action( 'geodir_wrapper_content_open', 'mom_action_wrapper_content_open', 9, 3 );
	
	// WRAPPER CONTENT CLOSE ACTIONS
	remove_action( 'geodir_wrapper_content_close', 'geodir_action_wrapper_content_close', 10);
	add_action( 'geodir_wrapper_content_close', 'mom_action_wrapper_content_close', 11);
	
	// SIDEBAR RIGHT OPEN ACTIONS
	remove_action( 'geodir_sidebar_right_open', 'geodir_action_sidebar_right_open', 10 );
	add_action( 'geodir_sidebar_right_open', 'mom_action_sidebar_right_open', 10, 4 );
	
	// SIDEBAR RIGHT CLOSE ACTIONS
	remove_action( 'geodir_sidebar_right_close', 'geodir_action_sidebar_right_close', 10);
	add_action( 'geodir_sidebar_right_close', 'mom_action_sidebar_right_close', 10,1);
	
	// HOME PAGE BREADCRUMBS
	remove_action( 'geodir_home_before_main_content', 'geodir_breadcrumb', 20 );
	
	// LISTINGS PAGE BREADCRUMBS & TITLES
	 remove_action( 'geodir_listings_before_main_content', 'geodir_breadcrumb', 20 );
	remove_action( 'geodir_listings_page_title', 'geodir_action_listings_title',10);
	
	// DETAILS PAGE BREADCRUMBS & TITLES
	 remove_action( 'geodir_detail_before_main_content', 'geodir_breadcrumb', 20 );
	remove_action( 'geodir_details_main_content', 'geodir_action_page_title',20);
	
	// SEARCH PAGE BREADCRUMBS & TITLES
	 remove_action( 'geodir_search_before_main_content', 'geodir_breadcrumb', 20 );
	remove_action( 'geodir_search_page_title', 'geodir_action_search_page_title',10);
	
	// AUTHOR PAGE BREADCRUMBS & TITLES
	 remove_action( 'geodir_author_before_main_content', 'geodir_breadcrumb', 20 );
	remove_action( 'geodir_author_page_title', 'geodir_action_author_page_title',10);

	add_action('wp_head', 'mom_scripts_to');
		
} // Close mom_action_calls

/* FUNCTIONS
****************************************************************************************/

function wpgeo_mom_styles() {
    // Register the style like this for a plugin:
    wp_register_style( 'wpgeo-mn-style', plugins_url( '/css/geo.css', __FILE__ ), array(), 'all' );
    wp_enqueue_style( 'wpgeo-mn-style' );
}

function wpgeo_mn_body_class($classes) {
	$classes[] = 'wpgeo-mn';
	return $classes;
}

function mom_search_container_open() {
	echo '<div class="container">';
}

function mom_search_container_close() {
	echo '</div>';
}

function mom_action_wrapper_open(){
			echo '<div class="main-container clearfix">';
			if ( geodir_is_geodir_page() ) {
			echo '<section class="section full-width-section">';
        	dynamic_sidebar('geodir_home_top');
			echo '</section>';
			}
}


add_filter( 'geodir_breadcrumb', 'geodir_x_breadcrumb' );
function geodir_x_breadcrumb( $breadcrumb ) {
	$breadcrumb = str_replace( '<div class="geodir-breadcrumb clearfix"><ul id="breadcrumbs">', '<div class="post-crumbs entry-crumbs" xmlns:v="http://rdf.data-vocabulary.org/#">', $breadcrumb );
	$breadcrumb = str_replace( '<li>', '<div class="vbreadcrumb" typeof="v:Breadcrumb">', $breadcrumb );
	$breadcrumb = str_replace( '</li>', '</div>', $breadcrumb );
	$breadcrumb = str_replace( '</div></div>', '', $breadcrumb );
	return $breadcrumb;
}

add_filter( 'geodir_breadcrumb_separator', 'geodir_x_breadcrumb_separator' );
function geodir_x_breadcrumb_separator( $separator ) {
	$separator = str_replace( ' > ', '', $separator );
	return $separator;
}

function mom_action_wrapper_close(){
	echo '</div></div><!-- content ends here-->';
}

function mom_action_wrapper_content_open($type='',$id='',$class=''){
	echo "<div class='main-left'><div class='main-content'>";
	echo '<div class="site-content page-wrap">';
}

function mom_action_wrapper_content_close(){
	echo '</div></div></div>';
}

function mom_action_sidebar_right_open($type='',$id='',$class='',$itemtype=''){
	echo "<aside class='sidebar' role='complementary' itemscope='itemscope' itemtype='http://schema.org/WPSideBar'>";
}

function mom_action_sidebar_right_close($type=''){
	echo '</aside><!-- sidebar ends here-->';
}

function mom_scripts_to(){ ?>
	<script type="text/javascript">
	jQuery(document).ready(function($) {
		if ( $( ".geodir_full_page" ).length ) {
			if ($.trim($('.geodir_full_page').html()) === ''){
				$('.geodir_full_page').css({ 'display': 'none'});
			}
		}
	});
	</script>
<?php }